package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 函数对象feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.SueFunction;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface SueFunctionFeignApi {

  /**
   * 通过id查询函数对象
   * @param  id
   * @return R
   */
  @GetMapping("/sueFunction/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增函数对象
   * @param sueFunction 函数对象
   * @return R
   */
  @PostMapping("/sueFunction/add")
  public R save(@RequestBody SueFunction sueFunction);

  /**
   * 修改函数对象
   * @param sueFunction 函数对象
   * @return R
   */
  @PostMapping("/sueFunction/update")
  public R updateById(@RequestBody SueFunction sueFunction);

  /**
   * 通过id删除函数对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/sueFunction/del/{id}" )
  public R removeById(@PathVariable Long id);

}
