package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 函数参数表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.SueFunctionParam;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface SueFunctionParamFeignApi {

  /**
   * 通过id查询函数参数表
   * @param  id
   * @return R
   */
  @GetMapping("/sueFunctionParam/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增函数参数表
   * @param sueFunctionParam 函数参数表
   * @return R
   */
  @PostMapping("/sueFunctionParam/add")
  public R save(@RequestBody SueFunctionParam sueFunctionParam);

  /**
   * 修改函数参数表
   * @param sueFunctionParam 函数参数表
   * @return R
   */
  @PostMapping("/sueFunctionParam/update")
  public R updateById(@RequestBody SueFunctionParam sueFunctionParam);

  /**
   * 通过id删除函数参数表
   * @param  id
   * @return R
   */
  @DeleteMapping("/sueFunctionParam/del/{id}" )
  public R removeById(@PathVariable Long id);

}
