package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 函数类型表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.SueFunctionType;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface SueFunctionTypeFeignApi {

  /**
   * 通过id查询函数类型表
   * @param  id
   * @return R
   */
  @GetMapping("/sueFunctionType/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增函数类型表
   * @param sueFunctionType 函数类型表
   * @return R
   */
  @PostMapping("/sueFunctionType/add")
  public R save(@RequestBody SueFunctionType sueFunctionType);

  /**
   * 修改函数类型表
   * @param sueFunctionType 函数类型表
   * @return R
   */
  @PostMapping("/sueFunctionType/update")
  public R updateById(@RequestBody SueFunctionType sueFunctionType);

  /**
   * 通过id删除函数类型表
   * @param  id
   * @return R
   */
  @DeleteMapping("/sueFunctionType/del/{id}" )
  public R removeById(@PathVariable Long id);

}
