package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 运算符字典表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.SueOperator;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface SueOperatorFeignApi {

  /**
   * 通过id查询运算符字典表
   * @param  id
   * @return R
   */
  @GetMapping("/sueOperator/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增运算符字典表
   * @param sueOperator 运算符字典表
   * @return R
   */
  @PostMapping("/sueOperator/add")
  public R save(@RequestBody SueOperator sueOperator);

  /**
   * 修改运算符字典表
   * @param sueOperator 运算符字典表
   * @return R
   */
  @PostMapping("/sueOperator/update")
  public R updateById(@RequestBody SueOperator sueOperator);

  /**
   * 通过id删除运算符字典表
   * @param  id
   * @return R
   */
  @DeleteMapping("/sueOperator/del/{id}" )
  public R removeById(@PathVariable Long id);

}
