package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 校验信息表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ValidateLib;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ValidateLibFeignApi {

  /**
   * 通过id查询校验信息表
   * @param  id
   * @return R
   */
  @GetMapping("/validateLib/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增校验信息表
   * @param validateLib 校验信息表
   * @return R
   */
  @PostMapping("/validateLib/add")
  public R save(@RequestBody ValidateLib validateLib);

  /**
   * 修改校验信息表
   * @param validateLib 校验信息表
   * @return R
   */
  @PostMapping("/validateLib/update")
  public R updateById(@RequestBody ValidateLib validateLib);

  /**
   * 通过id删除校验信息表
   * @param  id
   * @return R
   */
  @DeleteMapping("/validateLib/del/{id}" )
  public R removeById(@PathVariable Long id);

}
