package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 业务对象基础信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Bo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 表id
   */
      private Long id;

  /**
   * 全局id
   */
  private Long uniqueId;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 租户名称
   */
  private String tenantName;

  /**
   * 名称
   */
  private String name;

  /**
   * 编码
   */
  private String code;

  /**
   * 别名
   */
  private String alias;

  /**
   * 标题
   */
  private String title;

  /**
   * 类型
   */
  private String boType;

  /**
   * 创建方式
   */
  private String createType;

  /**
   * 继承对象id
   */
  private Long parentBoId;

  /**
   * 系统类型
   */
  private String sysType;

  /**
   * 持久化信息
   */
  private String persistence;

  private Long publishBoId;

  private String publishFlag;

  /**
   * 说明信息
   */
  private String remark;

  /**
   * 版本
   */
  private String version;

  /**
   * 状态
   */
  private String status;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
