package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 业务对象API信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BoApi implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * ID
   */
      private Long id;

  /**
   * 对象ID
   */
  private Long boId;

  /**
   * API类型
   */
  private String apiType;

  /**
   * 操作项ID
   */
  private Long endpointId;

  /**
   * 名称
   */
  private String name;

  /**
   * 代码
   */
  private String code;

  /**
   * 请求方式
   */
  private String method;

  /**
   * URL地址
   */
  private String url;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
