package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 业务对象字段信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BoField implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 表id
   */
      private Long id;

  /**
   * 全局id
   */
  private Long uniqueId;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 业务对象id
   */
  private Long boId;

  /**
   * 来源字段ID
   */
  private Long fieldId;

  private Long publishFieldId;

  private String publishFlag;

  /**
   * 名称
   */
  private String name;

  /**
   * 编码
   */
  private String code;

  /**
   * 别名
   */
  private String alias;

  /**
   * 0:不是数组 1:数组
   */
  private String arrayType;

  /**
   * 类型
   */
  private String fieldType;

  private Long dictId;

  /**
   * 空标识
   */
  private String niKey;

  /**
   * 主键标识
   */
  private String fieldKey;

  /**
   * 缺省值
   */
  private String defaultValue;

  /**
   * 字段标题信息
   */
  private String title;

  /**
   * 字段说明信息
   */
  private String remark;

  /**
   * 字段提示信息
   */
  private String tips;

  /**
   * 显示位置
   */
  private Long sortPlace;

  /**
   * 状态
   */
  private String status;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 数据状态
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
