package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 业务对象关系信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BoRelationship implements Serializable {

  private static final long serialVersionUID=1L;

      private Long id;

  /**
   * 固定ID
   */
  private Long uniqueId;

  /**
   * 业务对象ID
   */
  private Long boId;

  private String relationName;

  /**
   * 关系标识
   */
  private String relationCode;

  private String relationType;

  /**
   * 业务对象关系字段ID
   */
  private Long boField;

  /**
   * 子业务对象ID
   */
  private Long joinBoId;

  /**
   * 关联对象字段信息
   */
  private Long joinField;

  /**
   * 主对象删除策略
   */
  private String boDelStrategy;

  /**
   * 主对象删除错误提示
   */
  private String boDelErrtips;

  /**
   * 关联对象删除策略
   */
  private String joinDelStrategy;

  /**
   * 关联对象删除错误提示
   */
  private String joinDelErrtips;

  /**
   * 描述信息
   */
  private String remark;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
