package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 部署环境列表信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DeployEnv implements Serializable {

  private static final long serialVersionUID=1L;

      private Long id;

  /**
   * 全局ID
   */
  private Long uniqueId;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 环境名称
   */
  private String name;

  /**
   * 环境CODE
   */
  private String code;

  /**
   * 别名信息
   */
  private String alias;

  /**
   * 说明信息
   */
  private String remark;

  /**
   * 环境地址信息
   */
  private String url;

  /**
   * 版本信息
   */
  private String version;

  /**
   * 应用状态
   */
  private String status;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
