package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 字典库明细信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DictDetail implements Serializable {

  private static final long serialVersionUID=1L;

      private Long id;

  /**
   * 字典id
   */
  private Long dictId;

  /**
   * 名称
   */
  private String name;

  /**
   * 编码
   */
  private String code;

  /**
   * 备注信息
   */
  private String remark;

  /**
   * 版本
   */
  private String version;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
