package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 领域信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Domain implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 表id
   */
      private Long id;

  /**
   * 名称
   */
  private String name;

  /**
   * 编码
   */
  private String code;

  /**
   * 父id
   */
  private Long parentId;

  /**
   * 排序位置
   */
  private Long sortPlace;

  /**
   * 标签集合
   */
  private String tips;

  /**
   * 备注信息
   */
  private String remark;

  /**
   * 版本
   */
  private String version;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
