package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 字段属性信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FieldAttribute implements Serializable {

  private static final long serialVersionUID=1L;

      private Long id;

  private Long fieldId;

  /**
   * 字段描述类型
   */
  private String discribeType;

  /**
   * 字段描述内容
   */
  private String discribeValue;

  /**
   * 是否可读
   */
  private String readType;

  /**
   * 是否可修改
   */
  private String editType;

  /**
   * 是否可空
   */
  private String canNil;

  /**
   * 是否锁定-锁定后不允许调整其他配置
   */
  private String lockType;

  /**
   * 是否可搜索
   */
  private String searchType;

  /**
   * 最大长度
   */
  private Integer maxSize;

  /**
   * 最小长度
   */
  private Integer mixSize;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
