package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 模块基础信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Module implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 表id
   */
      private Long id;

  /**
   * 全局id
   */
  private Long uniqueId;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 租户名称
   */
  private String tenantName;

  /**
   * 名称
   */
  private String name;

  /**
   * 编码
   */
  private String code;

  /**
   * 别名
   */
  private String alias;

  /**
   * 类型
   */
  private String moduleType;

  /**
   * 系统类型
   */
  private String sysType;

  /**
   * 发布来源模块id
   */
  private Long publishModuleId;

  /**
   * 发布标识
   */
  private String publishFlag;

  /**
   * 编译打包标记 0 失败 1 打包中 2 成功
   */
  private String packageFlag;

  /**
   * 说明信息
   */
  private String remark;

  /**
   * 版本
   */
  private String version;

  /**
   * 状态信息
   */
  private String status;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
