package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * paas平台client信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PaasClient implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键信息
   */
      private Long id;

  /**
   * 授权地址
   */
  private String authUrl;

  /**
   * 客户端唯一码
   */
  private String clientId;

  /**
   * 客户端安全码
   */
  private String clientSecret;

  /**
   * 跳转地址
   */
  private String redirectUri;

  /**
   * 范围
   */
  private String scope;

  /**
   * 组织ID
   */
  private Long organizationId;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUser;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUser;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;




        }
