package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 项目基础信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Project implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 表ID
   */
      private Long id;

  /**
   * 项目名称
   */
  private String name;

  /**
   * 项目所属组织信息
   */
  private String org;

  /**
   * 项目代码
   */
  private String code;

  /**
   * 项目别名
   */
  private String alias;

  /**
   * 说明信息
   */
  private String remark;

  /**
   * 版本信息
   */
  private String version;

  /**
   * 项目状态
   */
  private String status;

  /**
   * 创建用户
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUser;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新用户
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUser;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除表示
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
