package com.xforceplus.ultraman.bocp.metadata.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 前端配置信息
 * </p>
 *
 * @author wangzheng
 * @since 2020-09-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WebSetting implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id信息
   */
      private Long id;

  /**
   * 名称
   */
  private String name;

  /**
   * 配置信息
   */
  private String settingJson;

  /**
   * 版本信息
   */
  private String version;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  private LocalDateTime createTime;

  /**
   * 更新时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private LocalDateTime updateTime;

  /**
   * 删除标识
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




        }
