package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.App;
import com.xforceplus.ultraman.bocp.metadata.service.IAppService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 应用基础信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class AppController {

  @Autowired
  private IAppService appServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param app 应用基础信息
   * @return
   */
  @GetMapping("/apps" )
  public XfR getApps(XfPage page, App app) {
    return XfR.ok(appServiceImpl.page(page, Wrappers.query(app)));
  }

  /**
   * 通过id查询应用基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/apps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appServiceImpl.getById(id));
  }

  /**
   * 新增应用基础信息
   * @param app 应用基础信息
   * @return XfR
   */
  @PostMapping("/apps")
  public XfR save(@RequestBody App app) {
     return XfR.ok(appServiceImpl.save(app));
  }

  /**
   * 修改-传入修改后的全部数据应用基础信息
   * @param app 应用基础信息
   * @return XfR
   */
  @PutMapping("/apps/{id}")
  public XfR putUpdate(@RequestBody App app,@PathVariable Long id) {
      app.setId(id);
      return XfR.ok(appServiceImpl.updateById(app));
  }

  /**
   * 修改-传入修改的数据应用基础信息
   * @param app 应用基础信息
   * @return XfR
   */
  @PatchMapping("/apps/{id}")
  public XfR patchUpdate(@RequestBody App app,@PathVariable Long id) {
      App upapp = appServiceImpl.getById(id);
      if(upapp != null){
        upapp = ObjectCopyUtils.copyProperties(app,upapp,true);
      }
      return XfR.ok(appServiceImpl.updateById(upapp));
  }

  /**
   * 通过id删除应用基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appServiceImpl.removeById(id));
  }

}