package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.AppEnv;
import com.xforceplus.ultraman.bocp.metadata.service.IAppEnvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 应用环境表前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class AppEnvController {

  @Autowired
  private IAppEnvService appEnvServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appEnv 应用环境表
   * @return
   */
  @GetMapping("/appenvs" )
  public XfR getAppEnvs(XfPage page, AppEnv appEnv) {
    return XfR.ok(appEnvServiceImpl.page(page, Wrappers.query(appEnv)));
  }

  /**
   * 通过id查询应用环境表
   * @param  id
   * @return XfR
   */
  @GetMapping("/appenvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appEnvServiceImpl.getById(id));
  }

  /**
   * 新增应用环境表
   * @param appEnv 应用环境表
   * @return XfR
   */
  @PostMapping("/appenvs")
  public XfR save(@RequestBody AppEnv appEnv) {
     return XfR.ok(appEnvServiceImpl.save(appEnv));
  }

  /**
   * 修改-传入修改后的全部数据应用环境表
   * @param appEnv 应用环境表
   * @return XfR
   */
  @PutMapping("/appenvs/{id}")
  public XfR putUpdate(@RequestBody AppEnv appEnv,@PathVariable Long id) {
      appEnv.setId(id);
      return XfR.ok(appEnvServiceImpl.updateById(appEnv));
  }

  /**
   * 修改-传入修改的数据应用环境表
   * @param appEnv 应用环境表
   * @return XfR
   */
  @PatchMapping("/appenvs/{id}")
  public XfR patchUpdate(@RequestBody AppEnv appEnv,@PathVariable Long id) {
      AppEnv upappEnv = appEnvServiceImpl.getById(id);
      if(upappEnv != null){
        upappEnv = ObjectCopyUtils.copyProperties(appEnv,upappEnv,true);
      }
      return XfR.ok(appEnvServiceImpl.updateById(upappEnv));
  }

  /**
   * 通过id删除应用环境表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appenvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appEnvServiceImpl.removeById(id));
  }

}