package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Bo;
import com.xforceplus.ultraman.bocp.metadata.service.IBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 业务对象基础信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class BoController {

  @Autowired
  private IBoService boServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bo 业务对象基础信息
   * @return
   */
  @GetMapping("/bos" )
  public XfR getBos(XfPage page, Bo bo) {
    return XfR.ok(boServiceImpl.page(page, Wrappers.query(bo)));
  }

  /**
   * 通过id查询业务对象基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boServiceImpl.getById(id));
  }

  /**
   * 新增业务对象基础信息
   * @param bo 业务对象基础信息
   * @return XfR
   */
  @PostMapping("/bos")
  public XfR save(@RequestBody Bo bo) {
     return XfR.ok(boServiceImpl.save(bo));
  }

  /**
   * 修改-传入修改后的全部数据业务对象基础信息
   * @param bo 业务对象基础信息
   * @return XfR
   */
  @PutMapping("/bos/{id}")
  public XfR putUpdate(@RequestBody Bo bo,@PathVariable Long id) {
      bo.setId(id);
      return XfR.ok(boServiceImpl.updateById(bo));
  }

  /**
   * 修改-传入修改的数据业务对象基础信息
   * @param bo 业务对象基础信息
   * @return XfR
   */
  @PatchMapping("/bos/{id}")
  public XfR patchUpdate(@RequestBody Bo bo,@PathVariable Long id) {
      Bo upbo = boServiceImpl.getById(id);
      if(upbo != null){
        upbo = ObjectCopyUtils.copyProperties(bo,upbo,true);
      }
      return XfR.ok(boServiceImpl.updateById(upbo));
  }

  /**
   * 通过id删除业务对象基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boServiceImpl.removeById(id));
  }

}