package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoField;
import com.xforceplus.ultraman.bocp.metadata.service.IBoFieldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 业务对象字段信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class BoFieldController {

  @Autowired
  private IBoFieldService boFieldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boField 业务对象字段信息
   * @return
   */
  @GetMapping("/bofields" )
  public XfR getBoFields(XfPage page, BoField boField) {
    return XfR.ok(boFieldServiceImpl.page(page, Wrappers.query(boField)));
  }

  /**
   * 通过id查询业务对象字段信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bofields/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boFieldServiceImpl.getById(id));
  }

  /**
   * 新增业务对象字段信息
   * @param boField 业务对象字段信息
   * @return XfR
   */
  @PostMapping("/bofields")
  public XfR save(@RequestBody BoField boField) {
     return XfR.ok(boFieldServiceImpl.save(boField));
  }

  /**
   * 修改-传入修改后的全部数据业务对象字段信息
   * @param boField 业务对象字段信息
   * @return XfR
   */
  @PutMapping("/bofields/{id}")
  public XfR putUpdate(@RequestBody BoField boField,@PathVariable Long id) {
      boField.setId(id);
      return XfR.ok(boFieldServiceImpl.updateById(boField));
  }

  /**
   * 修改-传入修改的数据业务对象字段信息
   * @param boField 业务对象字段信息
   * @return XfR
   */
  @PatchMapping("/bofields/{id}")
  public XfR patchUpdate(@RequestBody BoField boField,@PathVariable Long id) {
      BoField upboField = boFieldServiceImpl.getById(id);
      if(upboField != null){
        upboField = ObjectCopyUtils.copyProperties(boField,upboField,true);
      }
      return XfR.ok(boFieldServiceImpl.updateById(upboField));
  }

  /**
   * 通过id删除业务对象字段信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bofields/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boFieldServiceImpl.removeById(id));
  }

}