package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.metadata.service.IBoRelationshipService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 业务对象关系信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class BoRelationshipController {

  @Autowired
  private IBoRelationshipService boRelationshipServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boRelationship 业务对象关系信息
   * @return
   */
  @GetMapping("/borelationships" )
  public XfR getBoRelationships(XfPage page, BoRelationship boRelationship) {
    return XfR.ok(boRelationshipServiceImpl.page(page, Wrappers.query(boRelationship)));
  }

  /**
   * 通过id查询业务对象关系信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/borelationships/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boRelationshipServiceImpl.getById(id));
  }

  /**
   * 新增业务对象关系信息
   * @param boRelationship 业务对象关系信息
   * @return XfR
   */
  @PostMapping("/borelationships")
  public XfR save(@RequestBody BoRelationship boRelationship) {
     return XfR.ok(boRelationshipServiceImpl.save(boRelationship));
  }

  /**
   * 修改-传入修改后的全部数据业务对象关系信息
   * @param boRelationship 业务对象关系信息
   * @return XfR
   */
  @PutMapping("/borelationships/{id}")
  public XfR putUpdate(@RequestBody BoRelationship boRelationship,@PathVariable Long id) {
      boRelationship.setId(id);
      return XfR.ok(boRelationshipServiceImpl.updateById(boRelationship));
  }

  /**
   * 修改-传入修改的数据业务对象关系信息
   * @param boRelationship 业务对象关系信息
   * @return XfR
   */
  @PatchMapping("/borelationships/{id}")
  public XfR patchUpdate(@RequestBody BoRelationship boRelationship,@PathVariable Long id) {
      BoRelationship upboRelationship = boRelationshipServiceImpl.getById(id);
      if(upboRelationship != null){
        upboRelationship = ObjectCopyUtils.copyProperties(boRelationship,upboRelationship,true);
      }
      return XfR.ok(boRelationshipServiceImpl.updateById(upboRelationship));
  }

  /**
   * 通过id删除业务对象关系信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/borelationships/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boRelationshipServiceImpl.removeById(id));
  }

}