package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldLib;
import com.xforceplus.ultraman.bocp.metadata.service.IFieldLibService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 字段库信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class FieldLibController {

  @Autowired
  private IFieldLibService fieldLibServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fieldLib 字段库信息
   * @return
   */
  @GetMapping("/fieldlibs" )
  public XfR getFieldLibs(XfPage page, FieldLib fieldLib) {
    return XfR.ok(fieldLibServiceImpl.page(page, Wrappers.query(fieldLib)));
  }

  /**
   * 通过id查询字段库信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/fieldlibs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fieldLibServiceImpl.getById(id));
  }

  /**
   * 新增字段库信息
   * @param fieldLib 字段库信息
   * @return XfR
   */
  @PostMapping("/fieldlibs")
  public XfR save(@RequestBody FieldLib fieldLib) {
     return XfR.ok(fieldLibServiceImpl.save(fieldLib));
  }

  /**
   * 修改-传入修改后的全部数据字段库信息
   * @param fieldLib 字段库信息
   * @return XfR
   */
  @PutMapping("/fieldlibs/{id}")
  public XfR putUpdate(@RequestBody FieldLib fieldLib,@PathVariable Long id) {
      fieldLib.setId(id);
      return XfR.ok(fieldLibServiceImpl.updateById(fieldLib));
  }

  /**
   * 修改-传入修改的数据字段库信息
   * @param fieldLib 字段库信息
   * @return XfR
   */
  @PatchMapping("/fieldlibs/{id}")
  public XfR patchUpdate(@RequestBody FieldLib fieldLib,@PathVariable Long id) {
      FieldLib upfieldLib = fieldLibServiceImpl.getById(id);
      if(upfieldLib != null){
        upfieldLib = ObjectCopyUtils.copyProperties(fieldLib,upfieldLib,true);
      }
      return XfR.ok(fieldLibServiceImpl.updateById(upfieldLib));
  }

  /**
   * 通过id删除字段库信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fieldlibs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fieldLibServiceImpl.removeById(id));
  }

}