package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Module;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 模块基础信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class ModuleController {

  @Autowired
  private IModuleService moduleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param module 模块基础信息
   * @return
   */
  @GetMapping("/modules" )
  public XfR getModules(XfPage page, Module module) {
    return XfR.ok(moduleServiceImpl.page(page, Wrappers.query(module)));
  }

  /**
   * 通过id查询模块基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/modules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(moduleServiceImpl.getById(id));
  }

  /**
   * 新增模块基础信息
   * @param module 模块基础信息
   * @return XfR
   */
  @PostMapping("/modules")
  public XfR save(@RequestBody Module module) {
     return XfR.ok(moduleServiceImpl.save(module));
  }

  /**
   * 修改-传入修改后的全部数据模块基础信息
   * @param module 模块基础信息
   * @return XfR
   */
  @PutMapping("/modules/{id}")
  public XfR putUpdate(@RequestBody Module module,@PathVariable Long id) {
      module.setId(id);
      return XfR.ok(moduleServiceImpl.updateById(module));
  }

  /**
   * 修改-传入修改的数据模块基础信息
   * @param module 模块基础信息
   * @return XfR
   */
  @PatchMapping("/modules/{id}")
  public XfR patchUpdate(@RequestBody Module module,@PathVariable Long id) {
      Module upmodule = moduleServiceImpl.getById(id);
      if(upmodule != null){
        upmodule = ObjectCopyUtils.copyProperties(module,upmodule,true);
      }
      return XfR.ok(moduleServiceImpl.updateById(upmodule));
  }

  /**
   * 通过id删除模块基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/modules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(moduleServiceImpl.removeById(id));
  }

}