package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Project;
import com.xforceplus.ultraman.bocp.metadata.service.IProjectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 项目基础信息前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class ProjectController {

  @Autowired
  private IProjectService projectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param project 项目基础信息
   * @return
   */
  @GetMapping("/projects" )
  public XfR getProjects(XfPage page, Project project) {
    return XfR.ok(projectServiceImpl.page(page, Wrappers.query(project)));
  }

  /**
   * 通过id查询项目基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/projects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectServiceImpl.getById(id));
  }

  /**
   * 新增项目基础信息
   * @param project 项目基础信息
   * @return XfR
   */
  @PostMapping("/projects")
  public XfR save(@RequestBody Project project) {
     return XfR.ok(projectServiceImpl.save(project));
  }

  /**
   * 修改-传入修改后的全部数据项目基础信息
   * @param project 项目基础信息
   * @return XfR
   */
  @PutMapping("/projects/{id}")
  public XfR putUpdate(@RequestBody Project project,@PathVariable Long id) {
      project.setId(id);
      return XfR.ok(projectServiceImpl.updateById(project));
  }

  /**
   * 修改-传入修改的数据项目基础信息
   * @param project 项目基础信息
   * @return XfR
   */
  @PatchMapping("/projects/{id}")
  public XfR patchUpdate(@RequestBody Project project,@PathVariable Long id) {
      Project upproject = projectServiceImpl.getById(id);
      if(upproject != null){
        upproject = ObjectCopyUtils.copyProperties(project,upproject,true);
      }
      return XfR.ok(projectServiceImpl.updateById(upproject));
  }

  /**
   * 通过id删除项目基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectServiceImpl.removeById(id));
  }

}