package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.UserInfo;
import com.xforceplus.ultraman.bocp.metadata.service.IUserInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * 前端控制器
 *
 * @author wangzheng
 * @date 2020-04-09
 */
@RestController
public class UserInfoController {

  @Autowired
  private IUserInfoService userInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userInfo 
   * @return
   */
  @GetMapping("/userinfos" )
  public XfR getUserInfos(XfPage page, UserInfo userInfo) {
    return XfR.ok(userInfoServiceImpl.page(page, Wrappers.query(userInfo)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/userinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userInfoServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param userInfo 
   * @return XfR
   */
  @PostMapping("/userinfos")
  public XfR save(@RequestBody UserInfo userInfo) {
     return XfR.ok(userInfoServiceImpl.save(userInfo));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param userInfo 
   * @return XfR
   */
  @PutMapping("/userinfos/{id}")
  public XfR putUpdate(@RequestBody UserInfo userInfo,@PathVariable Long id) {
      userInfo.setId(id);
      return XfR.ok(userInfoServiceImpl.updateById(userInfo));
  }

  /**
   * 修改-传入修改的数据
   * @param userInfo 
   * @return XfR
   */
  @PatchMapping("/userinfos/{id}")
  public XfR patchUpdate(@RequestBody UserInfo userInfo,@PathVariable Long id) {
      UserInfo upuserInfo = userInfoServiceImpl.getById(id);
      if(upuserInfo != null){
        upuserInfo = ObjectCopyUtils.copyProperties(userInfo,upuserInfo,true);
      }
      return XfR.ok(userInfoServiceImpl.updateById(upuserInfo));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/userinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userInfoServiceImpl.removeById(id));
  }

}