package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoApi;
import com.xforceplus.ultraman.bocp.metadata.service.IBoApiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务对象API信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class BoApiController {

  @Autowired
  private IBoApiService boApiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boApi 业务对象API信息
   * @return
   */
  @GetMapping("/boapis" )
  public XfR getBoApis(XfPage page, BoApi boApi) {
    return XfR.ok(boApiServiceImpl.page(page, Wrappers.query(boApi)));
  }

  /**
   * 通过id查询业务对象API信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/boapis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boApiServiceImpl.getById(id));
  }

  /**
   * 新增业务对象API信息
   * @param boApi 业务对象API信息
   * @return XfR
   */
  @PostMapping("/boapis")
  public XfR save(@RequestBody BoApi boApi) {
     return XfR.ok(boApiServiceImpl.save(boApi));
  }

  /**
   * 修改-传入修改后的全部数据业务对象API信息
   * @param boApi 业务对象API信息
   * @return XfR
   */
  @PutMapping("/boapis/{id}")
  public XfR putUpdate(@RequestBody BoApi boApi,@PathVariable Long id) {
      boApi.setId(id);
      return XfR.ok(boApiServiceImpl.updateById(boApi));
  }

  /**
   * 修改-传入修改的数据业务对象API信息
   * @param boApi 业务对象API信息
   * @return XfR
   */
  @PatchMapping("/boapis/{id}")
  public XfR patchUpdate(@RequestBody BoApi boApi,@PathVariable Long id) {
      BoApi upboApi = boApiServiceImpl.getById(id);
      if(upboApi != null){
        upboApi = ObjectCopyUtils.copyProperties(boApi,upboApi,true);
      }
      return XfR.ok(boApiServiceImpl.updateById(upboApi));
  }

  /**
   * 通过id删除业务对象API信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/boapis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boApiServiceImpl.removeById(id));
  }

  @PostMapping("/boapis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "boapi");
      params.put("request", condition);

     return XfR.ok(boApiServiceImpl.querys(params));
  }

}
