package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoDomain;
import com.xforceplus.ultraman.bocp.metadata.service.IBoDomainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务对象领域信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class BoDomainController {

  @Autowired
  private IBoDomainService boDomainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boDomain 业务对象领域信息
   * @return
   */
  @GetMapping("/bodomains" )
  public XfR getBoDomains(XfPage page, BoDomain boDomain) {
    return XfR.ok(boDomainServiceImpl.page(page, Wrappers.query(boDomain)));
  }

  /**
   * 通过id查询业务对象领域信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bodomains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boDomainServiceImpl.getById(id));
  }

  /**
   * 新增业务对象领域信息
   * @param boDomain 业务对象领域信息
   * @return XfR
   */
  @PostMapping("/bodomains")
  public XfR save(@RequestBody BoDomain boDomain) {
     return XfR.ok(boDomainServiceImpl.save(boDomain));
  }

  /**
   * 修改-传入修改后的全部数据业务对象领域信息
   * @param boDomain 业务对象领域信息
   * @return XfR
   */
  @PutMapping("/bodomains/{id}")
  public XfR putUpdate(@RequestBody BoDomain boDomain,@PathVariable Long id) {
      boDomain.setId(id);
      return XfR.ok(boDomainServiceImpl.updateById(boDomain));
  }

  /**
   * 修改-传入修改的数据业务对象领域信息
   * @param boDomain 业务对象领域信息
   * @return XfR
   */
  @PatchMapping("/bodomains/{id}")
  public XfR patchUpdate(@RequestBody BoDomain boDomain,@PathVariable Long id) {
      BoDomain upboDomain = boDomainServiceImpl.getById(id);
      if(upboDomain != null){
        upboDomain = ObjectCopyUtils.copyProperties(boDomain,upboDomain,true);
      }
      return XfR.ok(boDomainServiceImpl.updateById(upboDomain));
  }

  /**
   * 通过id删除业务对象领域信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bodomains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boDomainServiceImpl.removeById(id));
  }

  @PostMapping("/bodomains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bodomain");
      params.put("request", condition);

     return XfR.ok(boDomainServiceImpl.querys(params));
  }

}
