package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.metadata.service.IBoFieldAttributeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务对象字段属性信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class BoFieldAttributeController {

  @Autowired
  private IBoFieldAttributeService boFieldAttributeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boFieldAttribute 业务对象字段属性信息
   * @return
   */
  @GetMapping("/bofieldattributes" )
  public XfR getBoFieldAttributes(XfPage page, BoFieldAttribute boFieldAttribute) {
    return XfR.ok(boFieldAttributeServiceImpl.page(page, Wrappers.query(boFieldAttribute)));
  }

  /**
   * 通过id查询业务对象字段属性信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bofieldattributes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boFieldAttributeServiceImpl.getById(id));
  }

  /**
   * 新增业务对象字段属性信息
   * @param boFieldAttribute 业务对象字段属性信息
   * @return XfR
   */
  @PostMapping("/bofieldattributes")
  public XfR save(@RequestBody BoFieldAttribute boFieldAttribute) {
     return XfR.ok(boFieldAttributeServiceImpl.save(boFieldAttribute));
  }

  /**
   * 修改-传入修改后的全部数据业务对象字段属性信息
   * @param boFieldAttribute 业务对象字段属性信息
   * @return XfR
   */
  @PutMapping("/bofieldattributes/{id}")
  public XfR putUpdate(@RequestBody BoFieldAttribute boFieldAttribute,@PathVariable Long id) {
      boFieldAttribute.setId(id);
      return XfR.ok(boFieldAttributeServiceImpl.updateById(boFieldAttribute));
  }

  /**
   * 修改-传入修改的数据业务对象字段属性信息
   * @param boFieldAttribute 业务对象字段属性信息
   * @return XfR
   */
  @PatchMapping("/bofieldattributes/{id}")
  public XfR patchUpdate(@RequestBody BoFieldAttribute boFieldAttribute,@PathVariable Long id) {
      BoFieldAttribute upboFieldAttribute = boFieldAttributeServiceImpl.getById(id);
      if(upboFieldAttribute != null){
        upboFieldAttribute = ObjectCopyUtils.copyProperties(boFieldAttribute,upboFieldAttribute,true);
      }
      return XfR.ok(boFieldAttributeServiceImpl.updateById(upboFieldAttribute));
  }

  /**
   * 通过id删除业务对象字段属性信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bofieldattributes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boFieldAttributeServiceImpl.removeById(id));
  }

  @PostMapping("/bofieldattributes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bofieldattribute");
      params.put("request", condition);

     return XfR.ok(boFieldAttributeServiceImpl.querys(params));
  }

}
