package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoFieldValue;
import com.xforceplus.ultraman.bocp.metadata.service.IBoFieldValueService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 业务对象字段值信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class BoFieldValueController {

  @Autowired
  private IBoFieldValueService boFieldValueServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boFieldValue 业务对象字段值信息
   * @return
   */
  @GetMapping("/bofieldvalues" )
  public XfR getBoFieldValues(XfPage page, BoFieldValue boFieldValue) {
    return XfR.ok(boFieldValueServiceImpl.page(page, Wrappers.query(boFieldValue)));
  }

  /**
   * 通过id查询业务对象字段值信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bofieldvalues/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boFieldValueServiceImpl.getById(id));
  }

  /**
   * 新增业务对象字段值信息
   * @param boFieldValue 业务对象字段值信息
   * @return XfR
   */
  @PostMapping("/bofieldvalues")
  public XfR save(@RequestBody BoFieldValue boFieldValue) {
     return XfR.ok(boFieldValueServiceImpl.save(boFieldValue));
  }

  /**
   * 修改-传入修改后的全部数据业务对象字段值信息
   * @param boFieldValue 业务对象字段值信息
   * @return XfR
   */
  @PutMapping("/bofieldvalues/{id}")
  public XfR putUpdate(@RequestBody BoFieldValue boFieldValue,@PathVariable Long id) {
      boFieldValue.setId(id);
      return XfR.ok(boFieldValueServiceImpl.updateById(boFieldValue));
  }

  /**
   * 修改-传入修改的数据业务对象字段值信息
   * @param boFieldValue 业务对象字段值信息
   * @return XfR
   */
  @PatchMapping("/bofieldvalues/{id}")
  public XfR patchUpdate(@RequestBody BoFieldValue boFieldValue,@PathVariable Long id) {
      BoFieldValue upboFieldValue = boFieldValueServiceImpl.getById(id);
      if(upboFieldValue != null){
        upboFieldValue = ObjectCopyUtils.copyProperties(boFieldValue,upboFieldValue,true);
      }
      return XfR.ok(boFieldValueServiceImpl.updateById(upboFieldValue));
  }

  /**
   * 通过id删除业务对象字段值信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bofieldvalues/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boFieldValueServiceImpl.removeById(id));
  }

  @PostMapping("/bofieldvalues/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bofieldvalue");
      params.put("request", condition);

     return XfR.ok(boFieldValueServiceImpl.querys(params));
  }

}
