package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Dict;
import com.xforceplus.ultraman.bocp.metadata.service.IDictService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 字典库信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class DictController {

  @Autowired
  private IDictService dictServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dict 字典库信息
   * @return
   */
  @GetMapping("/dicts" )
  public XfR getDicts(XfPage page, Dict dict) {
    return XfR.ok(dictServiceImpl.page(page, Wrappers.query(dict)));
  }

  /**
   * 通过id查询字典库信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/dicts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dictServiceImpl.getById(id));
  }

  /**
   * 新增字典库信息
   * @param dict 字典库信息
   * @return XfR
   */
  @PostMapping("/dicts")
  public XfR save(@RequestBody Dict dict) {
     return XfR.ok(dictServiceImpl.save(dict));
  }

  /**
   * 修改-传入修改后的全部数据字典库信息
   * @param dict 字典库信息
   * @return XfR
   */
  @PutMapping("/dicts/{id}")
  public XfR putUpdate(@RequestBody Dict dict,@PathVariable Long id) {
      dict.setId(id);
      return XfR.ok(dictServiceImpl.updateById(dict));
  }

  /**
   * 修改-传入修改的数据字典库信息
   * @param dict 字典库信息
   * @return XfR
   */
  @PatchMapping("/dicts/{id}")
  public XfR patchUpdate(@RequestBody Dict dict,@PathVariable Long id) {
      Dict updict = dictServiceImpl.getById(id);
      if(updict != null){
        updict = ObjectCopyUtils.copyProperties(dict,updict,true);
      }
      return XfR.ok(dictServiceImpl.updateById(updict));
  }

  /**
   * 通过id删除字典库信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dicts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dictServiceImpl.removeById(id));
  }

  @PostMapping("/dicts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "dict");
      params.put("request", condition);

     return XfR.ok(dictServiceImpl.querys(params));
  }

}
