package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.DictDetail;
import com.xforceplus.ultraman.bocp.metadata.service.IDictDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 字典库明细信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class DictDetailController {

  @Autowired
  private IDictDetailService dictDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dictDetail 字典库明细信息
   * @return
   */
  @GetMapping("/dictdetails" )
  public XfR getDictDetails(XfPage page, DictDetail dictDetail) {
    return XfR.ok(dictDetailServiceImpl.page(page, Wrappers.query(dictDetail)));
  }

  /**
   * 通过id查询字典库明细信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/dictdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dictDetailServiceImpl.getById(id));
  }

  /**
   * 新增字典库明细信息
   * @param dictDetail 字典库明细信息
   * @return XfR
   */
  @PostMapping("/dictdetails")
  public XfR save(@RequestBody DictDetail dictDetail) {
     return XfR.ok(dictDetailServiceImpl.save(dictDetail));
  }

  /**
   * 修改-传入修改后的全部数据字典库明细信息
   * @param dictDetail 字典库明细信息
   * @return XfR
   */
  @PutMapping("/dictdetails/{id}")
  public XfR putUpdate(@RequestBody DictDetail dictDetail,@PathVariable Long id) {
      dictDetail.setId(id);
      return XfR.ok(dictDetailServiceImpl.updateById(dictDetail));
  }

  /**
   * 修改-传入修改的数据字典库明细信息
   * @param dictDetail 字典库明细信息
   * @return XfR
   */
  @PatchMapping("/dictdetails/{id}")
  public XfR patchUpdate(@RequestBody DictDetail dictDetail,@PathVariable Long id) {
      DictDetail updictDetail = dictDetailServiceImpl.getById(id);
      if(updictDetail != null){
        updictDetail = ObjectCopyUtils.copyProperties(dictDetail,updictDetail,true);
      }
      return XfR.ok(dictDetailServiceImpl.updateById(updictDetail));
  }

  /**
   * 通过id删除字典库明细信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dictdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dictDetailServiceImpl.removeById(id));
  }

  @PostMapping("/dictdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "dictdetail");
      params.put("request", condition);

     return XfR.ok(dictDetailServiceImpl.querys(params));
  }

}
