package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.DictEnv;
import com.xforceplus.ultraman.bocp.metadata.service.IDictEnvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应用环境表前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class DictEnvController {

  @Autowired
  private IDictEnvService dictEnvServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dictEnv 应用环境表
   * @return
   */
  @GetMapping("/dictenvs" )
  public XfR getDictEnvs(XfPage page, DictEnv dictEnv) {
    return XfR.ok(dictEnvServiceImpl.page(page, Wrappers.query(dictEnv)));
  }

  /**
   * 通过id查询应用环境表
   * @param  id
   * @return XfR
   */
  @GetMapping("/dictenvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dictEnvServiceImpl.getById(id));
  }

  /**
   * 新增应用环境表
   * @param dictEnv 应用环境表
   * @return XfR
   */
  @PostMapping("/dictenvs")
  public XfR save(@RequestBody DictEnv dictEnv) {
     return XfR.ok(dictEnvServiceImpl.save(dictEnv));
  }

  /**
   * 修改-传入修改后的全部数据应用环境表
   * @param dictEnv 应用环境表
   * @return XfR
   */
  @PutMapping("/dictenvs/{id}")
  public XfR putUpdate(@RequestBody DictEnv dictEnv,@PathVariable Long id) {
      dictEnv.setId(id);
      return XfR.ok(dictEnvServiceImpl.updateById(dictEnv));
  }

  /**
   * 修改-传入修改的数据应用环境表
   * @param dictEnv 应用环境表
   * @return XfR
   */
  @PatchMapping("/dictenvs/{id}")
  public XfR patchUpdate(@RequestBody DictEnv dictEnv,@PathVariable Long id) {
      DictEnv updictEnv = dictEnvServiceImpl.getById(id);
      if(updictEnv != null){
        updictEnv = ObjectCopyUtils.copyProperties(dictEnv,updictEnv,true);
      }
      return XfR.ok(dictEnvServiceImpl.updateById(updictEnv));
  }

  /**
   * 通过id删除应用环境表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dictenvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dictEnvServiceImpl.removeById(id));
  }

  @PostMapping("/dictenvs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "dictenv");
      params.put("request", condition);

     return XfR.ok(dictEnvServiceImpl.querys(params));
  }

}
