package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Domain;
import com.xforceplus.ultraman.bocp.metadata.service.IDomainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 领域信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class DomainController {

  @Autowired
  private IDomainService domainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param domain 领域信息
   * @return
   */
  @GetMapping("/domains" )
  public XfR getDomains(XfPage page, Domain domain) {
    return XfR.ok(domainServiceImpl.page(page, Wrappers.query(domain)));
  }

  /**
   * 通过id查询领域信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/domains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(domainServiceImpl.getById(id));
  }

  /**
   * 新增领域信息
   * @param domain 领域信息
   * @return XfR
   */
  @PostMapping("/domains")
  public XfR save(@RequestBody Domain domain) {
     return XfR.ok(domainServiceImpl.save(domain));
  }

  /**
   * 修改-传入修改后的全部数据领域信息
   * @param domain 领域信息
   * @return XfR
   */
  @PutMapping("/domains/{id}")
  public XfR putUpdate(@RequestBody Domain domain,@PathVariable Long id) {
      domain.setId(id);
      return XfR.ok(domainServiceImpl.updateById(domain));
  }

  /**
   * 修改-传入修改的数据领域信息
   * @param domain 领域信息
   * @return XfR
   */
  @PatchMapping("/domains/{id}")
  public XfR patchUpdate(@RequestBody Domain domain,@PathVariable Long id) {
      Domain updomain = domainServiceImpl.getById(id);
      if(updomain != null){
        updomain = ObjectCopyUtils.copyProperties(domain,updomain,true);
      }
      return XfR.ok(domainServiceImpl.updateById(updomain));
  }

  /**
   * 通过id删除领域信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/domains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(domainServiceImpl.removeById(id));
  }

  @PostMapping("/domains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "domain");
      params.put("request", condition);

     return XfR.ok(domainServiceImpl.querys(params));
  }

}
