package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Event;
import com.xforceplus.ultraman.bocp.metadata.service.IEventService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 事件信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class EventController {

  @Autowired
  private IEventService eventServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param event 事件信息
   * @return
   */
  @GetMapping("/events" )
  public XfR getEvents(XfPage page, Event event) {
    return XfR.ok(eventServiceImpl.page(page, Wrappers.query(event)));
  }

  /**
   * 通过id查询事件信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/events/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(eventServiceImpl.getById(id));
  }

  /**
   * 新增事件信息
   * @param event 事件信息
   * @return XfR
   */
  @PostMapping("/events")
  public XfR save(@RequestBody Event event) {
     return XfR.ok(eventServiceImpl.save(event));
  }

  /**
   * 修改-传入修改后的全部数据事件信息
   * @param event 事件信息
   * @return XfR
   */
  @PutMapping("/events/{id}")
  public XfR putUpdate(@RequestBody Event event,@PathVariable Long id) {
      event.setId(id);
      return XfR.ok(eventServiceImpl.updateById(event));
  }

  /**
   * 修改-传入修改的数据事件信息
   * @param event 事件信息
   * @return XfR
   */
  @PatchMapping("/events/{id}")
  public XfR patchUpdate(@RequestBody Event event,@PathVariable Long id) {
      Event upevent = eventServiceImpl.getById(id);
      if(upevent != null){
        upevent = ObjectCopyUtils.copyProperties(event,upevent,true);
      }
      return XfR.ok(eventServiceImpl.updateById(upevent));
  }

  /**
   * 通过id删除事件信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/events/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(eventServiceImpl.removeById(id));
  }

  @PostMapping("/events/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "event");
      params.put("request", condition);

     return XfR.ok(eventServiceImpl.querys(params));
  }

}
