package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 模块业务对象信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class ModuleBoController {

  @Autowired
  private IModuleBoService moduleBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param moduleBo 模块业务对象信息
   * @return
   */
  @GetMapping("/modulebos" )
  public XfR getModuleBos(XfPage page, ModuleBo moduleBo) {
    return XfR.ok(moduleBoServiceImpl.page(page, Wrappers.query(moduleBo)));
  }

  /**
   * 通过id查询模块业务对象信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/modulebos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(moduleBoServiceImpl.getById(id));
  }

  /**
   * 新增模块业务对象信息
   * @param moduleBo 模块业务对象信息
   * @return XfR
   */
  @PostMapping("/modulebos")
  public XfR save(@RequestBody ModuleBo moduleBo) {
     return XfR.ok(moduleBoServiceImpl.save(moduleBo));
  }

  /**
   * 修改-传入修改后的全部数据模块业务对象信息
   * @param moduleBo 模块业务对象信息
   * @return XfR
   */
  @PutMapping("/modulebos/{id}")
  public XfR putUpdate(@RequestBody ModuleBo moduleBo,@PathVariable Long id) {
      moduleBo.setId(id);
      return XfR.ok(moduleBoServiceImpl.updateById(moduleBo));
  }

  /**
   * 修改-传入修改的数据模块业务对象信息
   * @param moduleBo 模块业务对象信息
   * @return XfR
   */
  @PatchMapping("/modulebos/{id}")
  public XfR patchUpdate(@RequestBody ModuleBo moduleBo,@PathVariable Long id) {
      ModuleBo upmoduleBo = moduleBoServiceImpl.getById(id);
      if(upmoduleBo != null){
        upmoduleBo = ObjectCopyUtils.copyProperties(moduleBo,upmoduleBo,true);
      }
      return XfR.ok(moduleBoServiceImpl.updateById(upmoduleBo));
  }

  /**
   * 通过id删除模块业务对象信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/modulebos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(moduleBoServiceImpl.removeById(id));
  }

  @PostMapping("/modulebos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "modulebo");
      params.put("request", condition);

     return XfR.ok(moduleBoServiceImpl.querys(params));
  }

}
