package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleDomain;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleDomainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 模块领域信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class ModuleDomainController {

  @Autowired
  private IModuleDomainService moduleDomainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param moduleDomain 模块领域信息
   * @return
   */
  @GetMapping("/moduledomains" )
  public XfR getModuleDomains(XfPage page, ModuleDomain moduleDomain) {
    return XfR.ok(moduleDomainServiceImpl.page(page, Wrappers.query(moduleDomain)));
  }

  /**
   * 通过id查询模块领域信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/moduledomains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(moduleDomainServiceImpl.getById(id));
  }

  /**
   * 新增模块领域信息
   * @param moduleDomain 模块领域信息
   * @return XfR
   */
  @PostMapping("/moduledomains")
  public XfR save(@RequestBody ModuleDomain moduleDomain) {
     return XfR.ok(moduleDomainServiceImpl.save(moduleDomain));
  }

  /**
   * 修改-传入修改后的全部数据模块领域信息
   * @param moduleDomain 模块领域信息
   * @return XfR
   */
  @PutMapping("/moduledomains/{id}")
  public XfR putUpdate(@RequestBody ModuleDomain moduleDomain,@PathVariable Long id) {
      moduleDomain.setId(id);
      return XfR.ok(moduleDomainServiceImpl.updateById(moduleDomain));
  }

  /**
   * 修改-传入修改的数据模块领域信息
   * @param moduleDomain 模块领域信息
   * @return XfR
   */
  @PatchMapping("/moduledomains/{id}")
  public XfR patchUpdate(@RequestBody ModuleDomain moduleDomain,@PathVariable Long id) {
      ModuleDomain upmoduleDomain = moduleDomainServiceImpl.getById(id);
      if(upmoduleDomain != null){
        upmoduleDomain = ObjectCopyUtils.copyProperties(moduleDomain,upmoduleDomain,true);
      }
      return XfR.ok(moduleDomainServiceImpl.updateById(upmoduleDomain));
  }

  /**
   * 通过id删除模块领域信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/moduledomains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(moduleDomainServiceImpl.removeById(id));
  }

  @PostMapping("/moduledomains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "moduledomain");
      params.put("request", condition);

     return XfR.ok(moduleDomainServiceImpl.querys(params));
  }

}
