package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleEnv;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleEnvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应用环境表前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class ModuleEnvController {

  @Autowired
  private IModuleEnvService moduleEnvServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param moduleEnv 应用环境表
   * @return
   */
  @GetMapping("/moduleenvs" )
  public XfR getModuleEnvs(XfPage page, ModuleEnv moduleEnv) {
    return XfR.ok(moduleEnvServiceImpl.page(page, Wrappers.query(moduleEnv)));
  }

  /**
   * 通过id查询应用环境表
   * @param  id
   * @return XfR
   */
  @GetMapping("/moduleenvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(moduleEnvServiceImpl.getById(id));
  }

  /**
   * 新增应用环境表
   * @param moduleEnv 应用环境表
   * @return XfR
   */
  @PostMapping("/moduleenvs")
  public XfR save(@RequestBody ModuleEnv moduleEnv) {
     return XfR.ok(moduleEnvServiceImpl.save(moduleEnv));
  }

  /**
   * 修改-传入修改后的全部数据应用环境表
   * @param moduleEnv 应用环境表
   * @return XfR
   */
  @PutMapping("/moduleenvs/{id}")
  public XfR putUpdate(@RequestBody ModuleEnv moduleEnv,@PathVariable Long id) {
      moduleEnv.setId(id);
      return XfR.ok(moduleEnvServiceImpl.updateById(moduleEnv));
  }

  /**
   * 修改-传入修改的数据应用环境表
   * @param moduleEnv 应用环境表
   * @return XfR
   */
  @PatchMapping("/moduleenvs/{id}")
  public XfR patchUpdate(@RequestBody ModuleEnv moduleEnv,@PathVariable Long id) {
      ModuleEnv upmoduleEnv = moduleEnvServiceImpl.getById(id);
      if(upmoduleEnv != null){
        upmoduleEnv = ObjectCopyUtils.copyProperties(moduleEnv,upmoduleEnv,true);
      }
      return XfR.ok(moduleEnvServiceImpl.updateById(upmoduleEnv));
  }

  /**
   * 通过id删除应用环境表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/moduleenvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(moduleEnvServiceImpl.removeById(id));
  }

  @PostMapping("/moduleenvs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "moduleenv");
      params.put("request", condition);

     return XfR.ok(moduleEnvServiceImpl.querys(params));
  }

}
