package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.PaasClient;
import com.xforceplus.ultraman.bocp.metadata.service.IPaasClientService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * paas平台client信息前端控制器
 *
 * @author wangzheng
 * @date 2020-09-11
 */
@RestController
public class PaasClientController {

  @Autowired
  private IPaasClientService paasClientServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paasClient paas平台client信息
   * @return
   */
  @GetMapping("/paasclients" )
  public XfR getPaasClients(XfPage page, PaasClient paasClient) {
    return XfR.ok(paasClientServiceImpl.page(page, Wrappers.query(paasClient)));
  }

  /**
   * 通过id查询paas平台client信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/paasclients/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paasClientServiceImpl.getById(id));
  }

  /**
   * 新增paas平台client信息
   * @param paasClient paas平台client信息
   * @return XfR
   */
  @PostMapping("/paasclients")
  public XfR save(@RequestBody PaasClient paasClient) {
     return XfR.ok(paasClientServiceImpl.save(paasClient));
  }

  /**
   * 修改-传入修改后的全部数据paas平台client信息
   * @param paasClient paas平台client信息
   * @return XfR
   */
  @PutMapping("/paasclients/{id}")
  public XfR putUpdate(@RequestBody PaasClient paasClient,@PathVariable Long id) {
      paasClient.setId(id);
      return XfR.ok(paasClientServiceImpl.updateById(paasClient));
  }

  /**
   * 修改-传入修改的数据paas平台client信息
   * @param paasClient paas平台client信息
   * @return XfR
   */
  @PatchMapping("/paasclients/{id}")
  public XfR patchUpdate(@RequestBody PaasClient paasClient,@PathVariable Long id) {
      PaasClient uppaasClient = paasClientServiceImpl.getById(id);
      if(uppaasClient != null){
        uppaasClient = ObjectCopyUtils.copyProperties(paasClient,uppaasClient,true);
      }
      return XfR.ok(paasClientServiceImpl.updateById(uppaasClient));
  }

  /**
   * 通过id删除paas平台client信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paasclients/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paasClientServiceImpl.removeById(id));
  }

  @PostMapping("/paasclients/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "paasclient");
      params.put("request", condition);

     return XfR.ok(paasClientServiceImpl.querys(params));
  }

}
