package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.AppDeployLog;
import com.xforceplus.ultraman.bocp.metadata.service.IAppDeployLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 应用环境表前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class AppDeployLogController {

  @Autowired
  private IAppDeployLogService appDeployLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appDeployLog 应用环境表
   * @return
   */
  @GetMapping("/appdeploylogs" )
  public XfR getAppDeployLogs(XfPage page, AppDeployLog appDeployLog) {
    return XfR.ok(appDeployLogServiceImpl.page(page, Wrappers.query(appDeployLog)));
  }

  /**
   * 通过id查询应用环境表
   * @param  id
   * @return XfR
   */
  @GetMapping("/appdeploylogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appDeployLogServiceImpl.getById(id));
  }

  /**
   * 新增应用环境表
   * @param appDeployLog 应用环境表
   * @return XfR
   */
  @PostMapping("/appdeploylogs")
  public XfR save(@RequestBody AppDeployLog appDeployLog) {
     return XfR.ok(appDeployLogServiceImpl.save(appDeployLog));
  }

  /**
   * 修改-传入修改后的全部数据应用环境表
   * @param appDeployLog 应用环境表
   * @return XfR
   */
  @PutMapping("/appdeploylogs/{id}")
  public XfR putUpdate(@RequestBody AppDeployLog appDeployLog,@PathVariable Long id) {
      appDeployLog.setId(id);
      return XfR.ok(appDeployLogServiceImpl.updateById(appDeployLog));
  }

  /**
   * 修改-传入修改的数据应用环境表
   * @param appDeployLog 应用环境表
   * @return XfR
   */
  @PatchMapping("/appdeploylogs/{id}")
  public XfR patchUpdate(@RequestBody AppDeployLog appDeployLog,@PathVariable Long id) {
      AppDeployLog upappDeployLog = appDeployLogServiceImpl.getById(id);
      if(upappDeployLog != null){
        upappDeployLog = ObjectCopyUtils.copyProperties(appDeployLog,upappDeployLog,true);
      }
      return XfR.ok(appDeployLogServiceImpl.updateById(upappDeployLog));
  }

  /**
   * 通过id删除应用环境表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appdeploylogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appDeployLogServiceImpl.removeById(id));
  }

  @PostMapping("/appdeploylogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_deploy_log");
     params.put("request", condition);

     return XfR.ok(appDeployLogServiceImpl.querys(params));
  }

}
