package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.AppModule;
import com.xforceplus.ultraman.bocp.metadata.service.IAppModuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 应用模块信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class AppModuleController {

  @Autowired
  private IAppModuleService appModuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appModule 应用模块信息
   * @return
   */
  @GetMapping("/appmodules" )
  public XfR getAppModules(XfPage page, AppModule appModule) {
    return XfR.ok(appModuleServiceImpl.page(page, Wrappers.query(appModule)));
  }

  /**
   * 通过id查询应用模块信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/appmodules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appModuleServiceImpl.getById(id));
  }

  /**
   * 新增应用模块信息
   * @param appModule 应用模块信息
   * @return XfR
   */
  @PostMapping("/appmodules")
  public XfR save(@RequestBody AppModule appModule) {
     return XfR.ok(appModuleServiceImpl.save(appModule));
  }

  /**
   * 修改-传入修改后的全部数据应用模块信息
   * @param appModule 应用模块信息
   * @return XfR
   */
  @PutMapping("/appmodules/{id}")
  public XfR putUpdate(@RequestBody AppModule appModule,@PathVariable Long id) {
      appModule.setId(id);
      return XfR.ok(appModuleServiceImpl.updateById(appModule));
  }

  /**
   * 修改-传入修改的数据应用模块信息
   * @param appModule 应用模块信息
   * @return XfR
   */
  @PatchMapping("/appmodules/{id}")
  public XfR patchUpdate(@RequestBody AppModule appModule,@PathVariable Long id) {
      AppModule upappModule = appModuleServiceImpl.getById(id);
      if(upappModule != null){
        upappModule = ObjectCopyUtils.copyProperties(appModule,upappModule,true);
      }
      return XfR.ok(appModuleServiceImpl.updateById(upappModule));
  }

  /**
   * 通过id删除应用模块信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appmodules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appModuleServiceImpl.removeById(id));
  }

  @PostMapping("/appmodules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_module");
     params.put("request", condition);

     return XfR.ok(appModuleServiceImpl.querys(params));
  }

}
