package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.metadata.service.IBoFieldValidateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务对象字段校验信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class BoFieldValidateController {

  @Autowired
  private IBoFieldValidateService boFieldValidateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boFieldValidate 业务对象字段校验信息
   * @return
   */
  @GetMapping("/bofieldvalidates" )
  public XfR getBoFieldValidates(XfPage page, BoFieldValidate boFieldValidate) {
    return XfR.ok(boFieldValidateServiceImpl.page(page, Wrappers.query(boFieldValidate)));
  }

  /**
   * 通过id查询业务对象字段校验信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/bofieldvalidates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boFieldValidateServiceImpl.getById(id));
  }

  /**
   * 新增业务对象字段校验信息
   * @param boFieldValidate 业务对象字段校验信息
   * @return XfR
   */
  @PostMapping("/bofieldvalidates")
  public XfR save(@RequestBody BoFieldValidate boFieldValidate) {
     return XfR.ok(boFieldValidateServiceImpl.save(boFieldValidate));
  }

  /**
   * 修改-传入修改后的全部数据业务对象字段校验信息
   * @param boFieldValidate 业务对象字段校验信息
   * @return XfR
   */
  @PutMapping("/bofieldvalidates/{id}")
  public XfR putUpdate(@RequestBody BoFieldValidate boFieldValidate,@PathVariable Long id) {
      boFieldValidate.setId(id);
      return XfR.ok(boFieldValidateServiceImpl.updateById(boFieldValidate));
  }

  /**
   * 修改-传入修改的数据业务对象字段校验信息
   * @param boFieldValidate 业务对象字段校验信息
   * @return XfR
   */
  @PatchMapping("/bofieldvalidates/{id}")
  public XfR patchUpdate(@RequestBody BoFieldValidate boFieldValidate,@PathVariable Long id) {
      BoFieldValidate upboFieldValidate = boFieldValidateServiceImpl.getById(id);
      if(upboFieldValidate != null){
        upboFieldValidate = ObjectCopyUtils.copyProperties(boFieldValidate,upboFieldValidate,true);
      }
      return XfR.ok(boFieldValidateServiceImpl.updateById(upboFieldValidate));
  }

  /**
   * 通过id删除业务对象字段校验信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bofieldvalidates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boFieldValidateServiceImpl.removeById(id));
  }

  @PostMapping("/bofieldvalidates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo_field_validate");
     params.put("request", condition);

     return XfR.ok(boFieldValidateServiceImpl.querys(params));
  }

}
