package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoIndex;
import com.xforceplus.ultraman.bocp.metadata.service.IBoIndexService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务对象关系信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class BoIndexController {

  @Autowired
  private IBoIndexService boIndexServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boIndex 业务对象关系信息
   * @return
   */
  @GetMapping("/boindexs" )
  public XfR getBoIndexs(XfPage page, BoIndex boIndex) {
    return XfR.ok(boIndexServiceImpl.page(page, Wrappers.query(boIndex)));
  }

  /**
   * 通过id查询业务对象关系信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/boindexs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boIndexServiceImpl.getById(id));
  }

  /**
   * 新增业务对象关系信息
   * @param boIndex 业务对象关系信息
   * @return XfR
   */
  @PostMapping("/boindexs")
  public XfR save(@RequestBody BoIndex boIndex) {
     return XfR.ok(boIndexServiceImpl.save(boIndex));
  }

  /**
   * 修改-传入修改后的全部数据业务对象关系信息
   * @param boIndex 业务对象关系信息
   * @return XfR
   */
  @PutMapping("/boindexs/{id}")
  public XfR putUpdate(@RequestBody BoIndex boIndex,@PathVariable Long id) {
      boIndex.setId(id);
      return XfR.ok(boIndexServiceImpl.updateById(boIndex));
  }

  /**
   * 修改-传入修改的数据业务对象关系信息
   * @param boIndex 业务对象关系信息
   * @return XfR
   */
  @PatchMapping("/boindexs/{id}")
  public XfR patchUpdate(@RequestBody BoIndex boIndex,@PathVariable Long id) {
      BoIndex upboIndex = boIndexServiceImpl.getById(id);
      if(upboIndex != null){
        upboIndex = ObjectCopyUtils.copyProperties(boIndex,upboIndex,true);
      }
      return XfR.ok(boIndexServiceImpl.updateById(upboIndex));
  }

  /**
   * 通过id删除业务对象关系信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/boindexs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boIndexServiceImpl.removeById(id));
  }

  @PostMapping("/boindexs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo_index");
     params.put("request", condition);

     return XfR.ok(boIndexServiceImpl.querys(params));
  }

}
