package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoOperatResume;
import com.xforceplus.ultraman.bocp.metadata.service.IBoOperatResumeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 奥特曼操作履历表前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class BoOperatResumeController {

  @Autowired
  private IBoOperatResumeService boOperatResumeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param boOperatResume 奥特曼操作履历表
   * @return
   */
  @GetMapping("/booperatresumes" )
  public XfR getBoOperatResumes(XfPage page, BoOperatResume boOperatResume) {
    return XfR.ok(boOperatResumeServiceImpl.page(page, Wrappers.query(boOperatResume)));
  }

  /**
   * 通过id查询奥特曼操作履历表
   * @param  id
   * @return XfR
   */
  @GetMapping("/booperatresumes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(boOperatResumeServiceImpl.getById(id));
  }

  /**
   * 新增奥特曼操作履历表
   * @param boOperatResume 奥特曼操作履历表
   * @return XfR
   */
  @PostMapping("/booperatresumes")
  public XfR save(@RequestBody BoOperatResume boOperatResume) {
     return XfR.ok(boOperatResumeServiceImpl.save(boOperatResume));
  }

  /**
   * 修改-传入修改后的全部数据奥特曼操作履历表
   * @param boOperatResume 奥特曼操作履历表
   * @return XfR
   */
  @PutMapping("/booperatresumes/{id}")
  public XfR putUpdate(@RequestBody BoOperatResume boOperatResume,@PathVariable Long id) {
      boOperatResume.setId(id);
      return XfR.ok(boOperatResumeServiceImpl.updateById(boOperatResume));
  }

  /**
   * 修改-传入修改的数据奥特曼操作履历表
   * @param boOperatResume 奥特曼操作履历表
   * @return XfR
   */
  @PatchMapping("/booperatresumes/{id}")
  public XfR patchUpdate(@RequestBody BoOperatResume boOperatResume,@PathVariable Long id) {
      BoOperatResume upboOperatResume = boOperatResumeServiceImpl.getById(id);
      if(upboOperatResume != null){
        upboOperatResume = ObjectCopyUtils.copyProperties(boOperatResume,upboOperatResume,true);
      }
      return XfR.ok(boOperatResumeServiceImpl.updateById(upboOperatResume));
  }

  /**
   * 通过id删除奥特曼操作履历表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/booperatresumes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(boOperatResumeServiceImpl.removeById(id));
  }

  @PostMapping("/booperatresumes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo_operat_resume");
     params.put("request", condition);

     return XfR.ok(boOperatResumeServiceImpl.querys(params));
  }

}
