package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ConfigServerRequest;
import com.xforceplus.ultraman.bocp.metadata.service.IConfigServerRequestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class ConfigServerRequestController {

  @Autowired
  private IConfigServerRequestService configServerRequestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configServerRequest 
   * @return
   */
  @GetMapping("/configserverrequests" )
  public XfR getConfigServerRequests(XfPage page, ConfigServerRequest configServerRequest) {
    return XfR.ok(configServerRequestServiceImpl.page(page, Wrappers.query(configServerRequest)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/configserverrequests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configServerRequestServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param configServerRequest 
   * @return XfR
   */
  @PostMapping("/configserverrequests")
  public XfR save(@RequestBody ConfigServerRequest configServerRequest) {
     return XfR.ok(configServerRequestServiceImpl.save(configServerRequest));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param configServerRequest 
   * @return XfR
   */
  @PutMapping("/configserverrequests/{id}")
  public XfR putUpdate(@RequestBody ConfigServerRequest configServerRequest,@PathVariable Long id) {
      configServerRequest.setId(id);
      return XfR.ok(configServerRequestServiceImpl.updateById(configServerRequest));
  }

  /**
   * 修改-传入修改的数据
   * @param configServerRequest 
   * @return XfR
   */
  @PatchMapping("/configserverrequests/{id}")
  public XfR patchUpdate(@RequestBody ConfigServerRequest configServerRequest,@PathVariable Long id) {
      ConfigServerRequest upconfigServerRequest = configServerRequestServiceImpl.getById(id);
      if(upconfigServerRequest != null){
        upconfigServerRequest = ObjectCopyUtils.copyProperties(configServerRequest,upconfigServerRequest,true);
      }
      return XfR.ok(configServerRequestServiceImpl.updateById(upconfigServerRequest));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configserverrequests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configServerRequestServiceImpl.removeById(id));
  }

  @PostMapping("/configserverrequests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_server_request");
     params.put("request", condition);

     return XfR.ok(configServerRequestServiceImpl.querys(params));
  }

}
