package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.DeployEnv;
import com.xforceplus.ultraman.bocp.metadata.service.IDeployEnvService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 部署环境列表信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class DeployEnvController {

  @Autowired
  private IDeployEnvService deployEnvServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deployEnv 部署环境列表信息
   * @return
   */
  @GetMapping("/deployenvs" )
  public XfR getDeployEnvs(XfPage page, DeployEnv deployEnv) {
    return XfR.ok(deployEnvServiceImpl.page(page, Wrappers.query(deployEnv)));
  }

  /**
   * 通过id查询部署环境列表信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/deployenvs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deployEnvServiceImpl.getById(id));
  }

  /**
   * 新增部署环境列表信息
   * @param deployEnv 部署环境列表信息
   * @return XfR
   */
  @PostMapping("/deployenvs")
  public XfR save(@RequestBody DeployEnv deployEnv) {
     return XfR.ok(deployEnvServiceImpl.save(deployEnv));
  }

  /**
   * 修改-传入修改后的全部数据部署环境列表信息
   * @param deployEnv 部署环境列表信息
   * @return XfR
   */
  @PutMapping("/deployenvs/{id}")
  public XfR putUpdate(@RequestBody DeployEnv deployEnv,@PathVariable Long id) {
      deployEnv.setId(id);
      return XfR.ok(deployEnvServiceImpl.updateById(deployEnv));
  }

  /**
   * 修改-传入修改的数据部署环境列表信息
   * @param deployEnv 部署环境列表信息
   * @return XfR
   */
  @PatchMapping("/deployenvs/{id}")
  public XfR patchUpdate(@RequestBody DeployEnv deployEnv,@PathVariable Long id) {
      DeployEnv updeployEnv = deployEnvServiceImpl.getById(id);
      if(updeployEnv != null){
        updeployEnv = ObjectCopyUtils.copyProperties(deployEnv,updeployEnv,true);
      }
      return XfR.ok(deployEnvServiceImpl.updateById(updeployEnv));
  }

  /**
   * 通过id删除部署环境列表信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deployenvs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deployEnvServiceImpl.removeById(id));
  }

  @PostMapping("/deployenvs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deploy_env");
     params.put("request", condition);

     return XfR.ok(deployEnvServiceImpl.querys(params));
  }

}
