package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldAttribute;
import com.xforceplus.ultraman.bocp.metadata.service.IFieldAttributeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 字段属性信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class FieldAttributeController {

  @Autowired
  private IFieldAttributeService fieldAttributeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fieldAttribute 字段属性信息
   * @return
   */
  @GetMapping("/fieldattributes" )
  public XfR getFieldAttributes(XfPage page, FieldAttribute fieldAttribute) {
    return XfR.ok(fieldAttributeServiceImpl.page(page, Wrappers.query(fieldAttribute)));
  }

  /**
   * 通过id查询字段属性信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/fieldattributes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fieldAttributeServiceImpl.getById(id));
  }

  /**
   * 新增字段属性信息
   * @param fieldAttribute 字段属性信息
   * @return XfR
   */
  @PostMapping("/fieldattributes")
  public XfR save(@RequestBody FieldAttribute fieldAttribute) {
     return XfR.ok(fieldAttributeServiceImpl.save(fieldAttribute));
  }

  /**
   * 修改-传入修改后的全部数据字段属性信息
   * @param fieldAttribute 字段属性信息
   * @return XfR
   */
  @PutMapping("/fieldattributes/{id}")
  public XfR putUpdate(@RequestBody FieldAttribute fieldAttribute,@PathVariable Long id) {
      fieldAttribute.setId(id);
      return XfR.ok(fieldAttributeServiceImpl.updateById(fieldAttribute));
  }

  /**
   * 修改-传入修改的数据字段属性信息
   * @param fieldAttribute 字段属性信息
   * @return XfR
   */
  @PatchMapping("/fieldattributes/{id}")
  public XfR patchUpdate(@RequestBody FieldAttribute fieldAttribute,@PathVariable Long id) {
      FieldAttribute upfieldAttribute = fieldAttributeServiceImpl.getById(id);
      if(upfieldAttribute != null){
        upfieldAttribute = ObjectCopyUtils.copyProperties(fieldAttribute,upfieldAttribute,true);
      }
      return XfR.ok(fieldAttributeServiceImpl.updateById(upfieldAttribute));
  }

  /**
   * 通过id删除字段属性信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fieldattributes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fieldAttributeServiceImpl.removeById(id));
  }

  @PostMapping("/fieldattributes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "field_attribute");
     params.put("request", condition);

     return XfR.ok(fieldAttributeServiceImpl.querys(params));
  }

}
