package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldType;
import com.xforceplus.ultraman.bocp.metadata.service.IFieldTypeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 字段类型前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class FieldTypeController {

  @Autowired
  private IFieldTypeService fieldTypeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fieldType 字段类型
   * @return
   */
  @GetMapping("/fieldtypes" )
  public XfR getFieldTypes(XfPage page, FieldType fieldType) {
    return XfR.ok(fieldTypeServiceImpl.page(page, Wrappers.query(fieldType)));
  }

  /**
   * 通过id查询字段类型
   * @param  id
   * @return XfR
   */
  @GetMapping("/fieldtypes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fieldTypeServiceImpl.getById(id));
  }

  /**
   * 新增字段类型
   * @param fieldType 字段类型
   * @return XfR
   */
  @PostMapping("/fieldtypes")
  public XfR save(@RequestBody FieldType fieldType) {
     return XfR.ok(fieldTypeServiceImpl.save(fieldType));
  }

  /**
   * 修改-传入修改后的全部数据字段类型
   * @param fieldType 字段类型
   * @return XfR
   */
  @PutMapping("/fieldtypes/{id}")
  public XfR putUpdate(@RequestBody FieldType fieldType,@PathVariable Long id) {
      fieldType.setId(id);
      return XfR.ok(fieldTypeServiceImpl.updateById(fieldType));
  }

  /**
   * 修改-传入修改的数据字段类型
   * @param fieldType 字段类型
   * @return XfR
   */
  @PatchMapping("/fieldtypes/{id}")
  public XfR patchUpdate(@RequestBody FieldType fieldType,@PathVariable Long id) {
      FieldType upfieldType = fieldTypeServiceImpl.getById(id);
      if(upfieldType != null){
        upfieldType = ObjectCopyUtils.copyProperties(fieldType,upfieldType,true);
      }
      return XfR.ok(fieldTypeServiceImpl.updateById(upfieldType));
  }

  /**
   * 通过id删除字段类型
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fieldtypes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fieldTypeServiceImpl.removeById(id));
  }

  @PostMapping("/fieldtypes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "field_type");
     params.put("request", condition);

     return XfR.ok(fieldTypeServiceImpl.querys(params));
  }

}
