package com.xforceplus.ultraman.bocp.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.WebSetting;
import com.xforceplus.ultraman.bocp.metadata.service.IWebSettingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端配置信息前端控制器
 *
 * @author wangzheng
 * @date 2020-12-14
 */
@RestController
public class WebSettingController {

  @Autowired
  private IWebSettingService webSettingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param webSetting 前端配置信息
   * @return
   */
  @GetMapping("/websettings" )
  public XfR getWebSettings(XfPage page, WebSetting webSetting) {
    return XfR.ok(webSettingServiceImpl.page(page, Wrappers.query(webSetting)));
  }

  /**
   * 通过id查询前端配置信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/websettings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(webSettingServiceImpl.getById(id));
  }

  /**
   * 新增前端配置信息
   * @param webSetting 前端配置信息
   * @return XfR
   */
  @PostMapping("/websettings")
  public XfR save(@RequestBody WebSetting webSetting) {
     return XfR.ok(webSettingServiceImpl.save(webSetting));
  }

  /**
   * 修改-传入修改后的全部数据前端配置信息
   * @param webSetting 前端配置信息
   * @return XfR
   */
  @PutMapping("/websettings/{id}")
  public XfR putUpdate(@RequestBody WebSetting webSetting,@PathVariable Long id) {
      webSetting.setId(id);
      return XfR.ok(webSettingServiceImpl.updateById(webSetting));
  }

  /**
   * 修改-传入修改的数据前端配置信息
   * @param webSetting 前端配置信息
   * @return XfR
   */
  @PatchMapping("/websettings/{id}")
  public XfR patchUpdate(@RequestBody WebSetting webSetting,@PathVariable Long id) {
      WebSetting upwebSetting = webSettingServiceImpl.getById(id);
      if(upwebSetting != null){
        upwebSetting = ObjectCopyUtils.copyProperties(webSetting,upwebSetting,true);
      }
      return XfR.ok(webSettingServiceImpl.updateById(upwebSetting));
  }

  /**
   * 通过id删除前端配置信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/websettings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(webSettingServiceImpl.removeById(id));
  }

  @PostMapping("/websettings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "web_setting");
     params.put("request", condition);

     return XfR.ok(webSettingServiceImpl.querys(params));
  }

}
