package com.xforceplus.ultramanbocp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanbocp.entity.CompanyA;
import com.xforceplus.ultramanbocp.service.ICompanyAService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-02-01
 */
@RestController
public class CompanyAController {

  @Autowired
  private ICompanyAService companyAServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param companyA ${table.comment}
   * @return
   */
  @GetMapping("/companyas" )
  public XfR getCompanyAs(XfPage page, CompanyA companyA) {
    return XfR.ok(companyAServiceImpl.page(page, Wrappers.query(companyA)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companyas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyAServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param companyA ${table.comment}
   * @return XfR
   */
  @PostMapping("/companyas")
  public XfR save(@RequestBody CompanyA companyA) {
     return XfR.ok(companyAServiceImpl.save(companyA));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param companyA ${table.comment}
   * @return XfR
   */
  @PutMapping("/companyas/{id}")
  public XfR putUpdate(@RequestBody CompanyA companyA,@PathVariable Long id) {
      companyA.setId(id);
      return XfR.ok(companyAServiceImpl.updateById(companyA));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param companyA ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companyas/{id}")
  public XfR patchUpdate(@RequestBody CompanyA companyA,@PathVariable Long id) {
      CompanyA upcompanyA = companyAServiceImpl.getById(id);
      if(upcompanyA != null){
        upcompanyA = ObjectCopyUtils.copyProperties(companyA,upcompanyA,true);
      }
      return XfR.ok(companyAServiceImpl.updateById(upcompanyA));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companyas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyAServiceImpl.removeById(id));
  }

  @PostMapping("/companyas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(companyAServiceImpl.querys(params));
  }

}
